/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.TimeUnit;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.util.PermissionsUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/stat.c")
public final class Stat {
    private Stat() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"The following restrictions apply to data accuracy:", "device number, inode number, number of links and", "device minor number are set to zero; both user and", "group ID are set to one; file kind is set to one if it", "is a directory, to four if is is a link, to zero otherwise;", "modification and status change time are set to", "modification time."}, parameterTypes={"string"}, returnType="Unix.stats")
    public static Value unix_stat(Value value) throws FailException {
        return Stat.createStats(false, CurrentContext.FILES_STATE.getRealFile(value));
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Exact synonym of [unix_stat]."}, parameterTypes={"string"}, returnType="Unix.stats")
    public static Value unix_lstat(Value value) throws FailException {
        return Stat.unix_stat(value);
    }

    @Primitive(compatibility=PrimitiveCompatibility.NOT_IMPLEMENTED, parameterTypes={"Unix.file_descr"}, returnType="Unix.stats")
    public static Value unix_fstat(Value value) throws FailException {
        Fail.invalidArgument("Unix.fstat not implemented");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"The restrictions of [unix_stat] apply."}, parameterTypes={"Unix.file_descr"}, returnType="Unix.stats")
    public static Value unix_stat_64(Value value) throws FailException {
        return Stat.createStats(true, CurrentContext.FILES_STATE.getRealFile(value));
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Exact synonym of [unix_stat_64]."}, parameterTypes={"string"}, returnType="Unix.stats")
    public static Value unix_lstat_64(Value value) throws FailException {
        return Stat.unix_stat_64(value);
    }

    @Primitive(compatibility=PrimitiveCompatibility.NOT_IMPLEMENTED, parameterTypes={"Unix.file_descr"}, returnType="Unix.stats")
    public static Value unix_fstat_64(Value value) throws FailException {
        Fail.invalidArgument("Unix.fstat_64 not implemented");
        return Value.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Value createStats(boolean bl, File file) throws FailException {
        Object object;
        Path path = file.toPath();
        if (!file.exists()) {
            Unix.fail("stat", "file does not exist");
            return Value.UNIT;
        }
        double d = (double)file.lastModified() / 1000.0;
        double d2 = (double)file.lastModified() / 1000.0;
        try {
            object = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            d = object.lastModifiedTime().to(TimeUnit.SECONDS);
            d2 = object.lastAccessTime().to(TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = bl ? Value.createInt64(file.length()) : Value.createLong((int)file.length());
        Value value = Value.ZERO;
        try {
            value = Value.createLong(PermissionsUtils.getPermissions(file));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl2 = false;
        try {
            bl2 = Files.readSymbolicLink(path) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Value value2 = Value.createBlock(0, 12L);
        value2.set0(Value.ZERO);
        value2.set1(Value.ZERO);
        value2.set2(bl2 ? Value.FOUR : (file.isDirectory() ? Value.ONE : Value.ZERO));
        value2.set3(value);
        value2.set4(Value.ZERO);
        value2.set5(Value.ONE);
        value2.set6(Value.ONE);
        value2.set7(Value.ZERO);
        value2.set(8, (Value)object);
        value2.set(9, Value.createDouble(d2));
        value2.set(10, Value.createDouble(d));
        value2.set(11, Value.createDouble(d));
        return value2;
    }
}

