/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.TimeoutException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Phaser", source="")
public final class Phaser {
    private Phaser() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t option", "int32"}, returnType="Phaser.t")
    public static Value ocamljava_phaser_make(Value value, Value value2) throws FailException {
        java.util.concurrent.Phaser phaser = value.isLong() ? null : (java.util.concurrent.Phaser)value.get0().asCustom();
        try {
            return Value.createInstance(new java.util.concurrent.Phaser(phaser, value2.asInt32()));
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Phaser.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_arrive(Value value) throws FailException {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        try {
            int n = phaser.arrive();
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Phaser.arrive");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_arrive_and_await_advance(Value value) throws FailException {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        try {
            int n = phaser.arriveAndAwaitAdvance();
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Phaser.arrive_and_await_advance");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_arrive_and_deregister(Value value) throws FailException {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        try {
            int n = phaser.arriveAndDeregister();
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Phaser.arrive_and_deregister");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t", "int32"}, returnType="int32")
    public static Value ocamljava_phaser_await_advance(Value value, Value value2) {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        int n = phaser.awaitAdvance(value2.asInt32());
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t", "int32"}, returnType="int32")
    public static Value ocamljava_phaser_await_advance_interruptibly(Value value, Value value2) throws FailException {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        try {
            int n = phaser.awaitAdvanceInterruptibly(value2.asInt32());
            return Value.createInt32(n);
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Phaser.await_advance_interruptibly");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t", "int32", "int64", "TimeUnit.t"}, returnType="int32")
    public static Value ocamljava_phaser_await_advance_interruptibly_time(Value value, Value value2, Value value3, Value value4) throws FailException {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        try {
            int n = phaser.awaitAdvanceInterruptibly(value2.asInt32(), value3.asInt64(), TimeUnit.decode(value4));
            return Value.createInt32(n);
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Phaser.await_advance_interruptibly_time");
            return Value.UNIT;
        }
        catch (TimeoutException timeoutException) {
            Runtime.raiseTimeout("Concurrent.Phaser.await_advance_interruptibly_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t", "int32"}, returnType="int32")
    public static Value ocamljava_phaser_bulk_register(Value value, Value value2) throws FailException {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        try {
            int n = phaser.bulkRegister(value2.asInt32());
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Phaser.bulk_register");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="unit")
    public static Value ocamljava_phaser_force_termination(Value value) {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        phaser.forceTermination();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_get_arrived_parties(Value value) {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        int n = phaser.getArrivedParties();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="Phaser.t option")
    public static Value ocamljava_phaser_get_parent(Value value) {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        java.util.concurrent.Phaser phaser2 = phaser.getParent();
        return phaser2 == null ? Value.ZERO : Value.createBlock(0, Value.createInstance(phaser2));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_get_phase(Value value) {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        int n = phaser.getPhase();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_get_registered_parties(Value value) {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        int n = phaser.getRegisteredParties();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="Phaser.t")
    public static Value ocamljava_phaser_get_root(Value value) {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        java.util.concurrent.Phaser phaser2 = phaser.getParent();
        return Value.createInstance(phaser2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_get_unarrived_parties(Value value) {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        int n = phaser.getUnarrivedParties();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="bool")
    public static Value ocamljava_phaser_is_terminated(Value value) {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        boolean bl = phaser.isTerminated();
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_register(Value value) throws FailException {
        java.util.concurrent.Phaser phaser = (java.util.concurrent.Phaser)value.asCustom();
        try {
            int n = phaser.register();
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Phaser.register");
            return Value.UNIT;
        }
    }
}

