/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.jhelp;

import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class SwkJHelpCmd
implements Command {
    private static final String[] validCmds = new String[]{"init", "show", "enable", "enablekey", "popup"};
    private static final int OPT_INIT = 0;
    private static final int OPT_SHOW = 1;
    private static final int OPT_ENABLE = 2;
    private static final int OPT_ENABLEKEY = 3;
    private static final int OPT_POPUP = 4;
    HelpSet mainHS = null;
    HelpBroker mainHB;
    static final String helpsetName = "javahelpjhelpset";
    static final String helpsetLabel = "Demo NVJ - Help";
    static boolean gotDefaults = false;
    int index;
    Interp interp = null;

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        this.interp = interp;
        int opt = TclIndex.get((Interp)interp, (TclObject)argv[1], (String[])validCmds, (String)"option", (int)0);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                try {
                    ClassLoader cl = SwkJHelpCmd.class.getClassLoader();
                    URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)helpsetName);
                    this.mainHS = new HelpSet(cl, url);
                }
                catch (Exception ee) {
                    System.out.println("Help Set javahelpjhelpset not found");
                    return;
                }
                catch (ExceptionInInitializerError ex) {
                    System.err.println("initialization error:");
                    ex.getException().printStackTrace();
                }
                this.mainHB = this.mainHS.createHelpBroker();
                break;
            }
            case 1: {
                String targetName = argv[2].toString();
                new Show().exec(targetName);
                break;
            }
            case 2: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 2, argv, "option option");
                }
                TclObject tObj = (TclObject)Widgets.getWidget((Interp)interp, (String)argv[2].toString());
                if (tObj == null) {
                    throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
                }
                Object swkjobject = ReflectObject.get((Interp)interp, (TclObject)tObj);
                String targetName = argv[3].toString();
                Map m = this.mainHS.getCombinedMap();
                if (m.isValidID(targetName, this.mainHS)) {
                    this.mainHB.enableHelp((Component)swkjobject, targetName, null);
                    break;
                }
                throw new TclException(interp, "Tcl Exception: " + targetName + " is not valid Target");
            }
            case 3: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 2, argv, "option option");
                }
                TclObject tObj = (TclObject)Widgets.getWidget((Interp)interp, (String)argv[2].toString());
                if (tObj == null) {
                    throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
                }
                Object swkjobject = ReflectObject.get((Interp)interp, (TclObject)tObj);
                String targetName = argv[3].toString();
                Map m = this.mainHS.getCombinedMap();
                if (m.isValidID(targetName, this.mainHS)) {
                    this.mainHB.enableHelpKey((Component)swkjobject, targetName, null);
                    break;
                }
                throw new TclException(interp, "Tcl Exception: " + targetName + " is not valid Target");
            }
            case 4: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option option");
                }
                TclObject tObj = (TclObject)Widgets.getWidget((Interp)interp, (String)argv[2].toString());
                if (tObj == null) {
                    throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
                }
                Object swkjobject = ReflectObject.get((Interp)interp, (TclObject)tObj);
                JMenu comp = (JMenu)swkjobject;
                JMenuItem jcomp = comp.getItem(1);
                jcomp.addActionListener((ActionListener)new CSH.DisplayHelpAfterTracking(this.mainHS, "javax.help.Popup", null));
            }
        }
    }

    public static void setTarget(Component comp, String targetName) {
        CSH.setHelpIDString((Component)comp, (String)targetName);
    }

    class Show
    extends UpdateOnEventThread {
        String errMessage = null;
        String targetName = null;

        Show() {
        }

        void exec(String targetName) throws TclException {
            this.targetName = targetName;
            this.execOnThread();
            if (this.errMessage != null) {
                throw new TclException(SwkJHelpCmd.this.interp, this.errMessage);
            }
        }

        public void run() {
            SwkJHelpCmd.this.mainHB.setDisplayed(true);
            try {
                SwkJHelpCmd.this.mainHB.setCurrentID(this.targetName);
            }
            catch (BadIDException be) {
                System.out.println("Error: Target is not found!");
                SwkJHelpCmd.this.mainHB.setCurrentID("default");
            }
        }
    }
}

