/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlNumber;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.SimpleWrapper;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlInt32
extends OCamlValue
implements OCamlNumber {
    public static final Wrapper<OCamlInt32> WRAPPER = new SimpleWrapper<OCamlInt32>(){

        @Override
        public OCamlInt32 wrap(Value value) {
            return new OCamlInt32(value);
        }
    };

    private OCamlInt32(Value value) {
        super(value);
    }

    public Wrapper<? extends OCamlInt32> getWrapper() {
        return WRAPPER;
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int n) {
        return OCamlUnit.WRAPPER;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value.asInt32();
    }

    @Override
    public double doubleValue() {
        return this.value.asInt32();
    }

    @Override
    public float floatValue() {
        return this.value.asInt32();
    }

    @Override
    public int intValue() {
        return this.value.asInt32();
    }

    @Override
    public long longValue() {
        return this.value.asInt32();
    }

    @Override
    public short shortValue() {
        return (short)this.value.asInt32();
    }

    @Override
    public int hashCode() {
        return this.value.asInt32();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OCamlInt32) {
            OCamlInt32 oCamlInt32 = (OCamlInt32)object;
            return this.value.asInt32() == oCamlInt32.value.asInt32();
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OCamlInt32(");
        stringBuilder.append(this.value.asInt32());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static OCamlInt32 create(int n) {
        return new OCamlInt32(Value.createInt32(n));
    }

    public static OCamlInt32 wrap(Value value) {
        assert (value != null) : "null v";
        return new OCamlInt32(value);
    }

    public static Wrapper<? extends OCamlInt32> wrapper() {
        return WRAPPER;
    }
}

