/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.util.Formatter;
import java.util.Locale;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.stdlib.Compare;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Pervasives", source="byterun/floats.c")
public final class Floats {
    private static final Value FP_NORMAL = Value.ZERO;
    private static final Value FP_SUBNORMAL = Value.ONE;
    private static final Value FP_ZERO = Value.TWO;
    private static final Value FP_INFINITE = Value.THREE;
    private static final Value FP_NAN = Value.FOUR;

    private Floats() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "float"}, returnType="string")
    public static Value caml_format_float(Value value, Value value2) {
        double d = value2.asDouble();
        if (Double.isNaN(d)) {
            return Value.createString("nan");
        }
        if (Double.isInfinite(d)) {
            if (d < 0.0) {
                return Value.createString("-inf");
            }
            return Value.createString("inf");
        }
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder, Locale.US);
        String string = value.asString();
        formatter.format(string, d);
        boolean bl = stringBuilder.indexOf("e") >= 0 || stringBuilder.indexOf("E") >= 0;
        switch (string.charAt(string.length() - 1)) {
            case 'F': {
                if (bl) break;
                while (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                break;
            }
            case 'G': 
            case 'g': {
                if (!bl) {
                    while (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
                        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    }
                }
                if (stringBuilder.charAt(stringBuilder.length() - 1) != '.') break;
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
        }
        return Value.createString(formatter.toString());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="float")
    public static Value caml_float_of_string(Value value) throws FailException {
        String string = value.asString();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '_') continue;
            stringBuilder.append(c);
        }
        if (stringBuilder.length() == 0) {
            Fail.failWith("float_of_string");
            return Value.UNIT;
        }
        try {
            return Value.createDouble(Double.parseDouble(stringBuilder.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            Fail.failWith("float_of_string");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="int")
    public static Value caml_int_of_float(Value value) {
        return Value.createLong((long)value.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="float")
    public static Value caml_float_of_int(Value value) {
        return Value.createDouble(value.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_neg_float(Value value) {
        return Value.createDouble(-value.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_abs_float(Value value) {
        return Value.createDouble(Math.abs(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_add_float(Value value, Value value2) {
        return Value.createDouble(value.asDouble() + value2.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_sub_float(Value value, Value value2) {
        return Value.createDouble(value.asDouble() - value2.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_mul_float(Value value, Value value2) {
        return Value.createDouble(value.asDouble() * value2.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_div_float(Value value, Value value2) {
        return Value.createDouble(value.asDouble() / value2.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_exp_float(Value value) {
        return Value.createDouble(Math.exp(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_floor_float(Value value) {
        return Value.createDouble(Math.floor(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_fmod_float(Value value, Value value2) {
        return Value.createDouble(value.asDouble() % value2.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float * float")
    public static Value caml_frexp_float(Value value) {
        long l;
        double d;
        block4: {
            double d2;
            block3: {
                d2 = value.asDouble();
                if (Double.isNaN(d2) || Double.isInfinite(d2) || d2 == 0.0) {
                    return Value.createBlock(0, Value.createDouble(d2), Value.ZERO);
                }
                d = Math.signum(d2);
                d2 = Math.abs(d2);
                l = 0L;
                if (!(d2 >= 1.0)) break block3;
                while (d2 >= 1.0) {
                    d2 /= 2.0;
                    ++l;
                }
                break block4;
            }
            if (!(d2 < 0.5)) break block4;
            while (d2 < 0.5) {
                d2 *= 2.0;
                --l;
            }
        }
        return Value.createBlock(0, Value.createDouble(d2 *= d), Value.createLong(l));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "int"}, returnType="float")
    public static Value caml_ldexp_float(Value value, Value value2) {
        return Value.createDouble(value.asDouble() * Math.pow(2.0, value2.asLong()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_log_float(Value value) {
        return Value.createDouble(Math.log(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_log10_float(Value value) {
        return Value.createDouble(Math.log10(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float * float")
    public static Value caml_modf_float(Value value) {
        double d = value.asDouble();
        double d2 = Math.abs(d);
        boolean bl = d < 0.0;
        double d3 = Math.floor(d2);
        double d4 = d2 - d3;
        return Value.createBlock(0, Value.createDouble(bl ? -d4 : d4), Value.createDouble(bl ? -d3 : d3));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_sqrt_float(Value value) {
        return Value.createDouble(Math.sqrt(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_power_float(Value value, Value value2) {
        return Value.createDouble(Math.pow(value.asDouble(), value2.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_sin_float(Value value) {
        return Value.createDouble(Math.sin(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_sinh_float(Value value) {
        return Value.createDouble(Math.sinh(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_cos_float(Value value) {
        return Value.createDouble(Math.cos(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_cosh_float(Value value) {
        return Value.createDouble(Math.cosh(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_tan_float(Value value) {
        return Value.createDouble(Math.tan(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_tanh_float(Value value) {
        return Value.createDouble(Math.tanh(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_asin_float(Value value) {
        return Value.createDouble(Math.asin(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_acos_float(Value value) {
        return Value.createDouble(Math.acos(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_atan_float(Value value) {
        return Value.createDouble(Math.atan(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_atan2_float(Value value, Value value2) {
        return Value.createDouble(Math.atan2(value.asDouble(), value2.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_ceil_float(Value value) {
        return Value.createDouble(Math.ceil(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_hypot_float(Value value, Value value2) {
        return Value.createDouble(Math.hypot(value.asDouble(), value2.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_expm1_float(Value value) {
        return Value.createDouble(Math.expm1(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_log1p_float(Value value) {
        return Value.createDouble(Math.log1p(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_copysign_float(Value value, Value value2) {
        return Value.createDouble(Math.copySign(value.asDouble(), value2.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="bool")
    public static Value caml_eq_float(Value value, Value value2) {
        return value.asDouble() == value2.asDouble() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="bool")
    public static Value caml_neq_float(Value value, Value value2) {
        return value.asDouble() != value2.asDouble() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="bool")
    public static Value caml_le_float(Value value, Value value2) {
        return value.asDouble() <= value2.asDouble() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="bool")
    public static Value caml_lt_float(Value value, Value value2) {
        return value.asDouble() < value2.asDouble() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="bool")
    public static Value caml_ge_float(Value value, Value value2) {
        return value.asDouble() >= value2.asDouble() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="bool")
    public static Value caml_gt_float(Value value, Value value2) {
        return value.asDouble() > value2.asDouble() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="int")
    public static Value caml_float_compare(Value value, Value value2) {
        double d = value.asDouble();
        double d2 = value2.asDouble();
        if (Double.isNaN(d)) {
            if (Double.isNaN(d2)) {
                return Compare.EQUAL_VALUE;
            }
            return Compare.LESS_VALUE;
        }
        if (Double.isNaN(d2)) {
            return Compare.GREATER_VALUE;
        }
        if (d < d2) {
            return Compare.LESS_VALUE;
        }
        if (d > d2) {
            return Compare.GREATER_VALUE;
        }
        return Compare.EQUAL_VALUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="Pervasives.fpclass")
    public static Value caml_classify_float(Value value) {
        long l = Double.doubleToRawLongBits(value.asDouble());
        int n = (int)(l >> 32 & 0xFFFFFFFFL);
        int n2 = (int)(l & 0xFFFFFFFFL);
        if (((n &= 0x7FF00000) | (n2 |= n & 0xFFFFF)) == 0) {
            return FP_ZERO;
        }
        if (n == 0) {
            return FP_SUBNORMAL;
        }
        if (n == 0x7FF00000) {
            if (n2 == 0) {
                return FP_INFINITE;
            }
            return FP_NAN;
        }
        return FP_NORMAL;
    }
}

