/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicInt32", source="")
public final class AtomicInt32 {
    private AtomicInt32() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32"}, returnType="AtomicInt32.t")
    public static Value ocamljava_atomicint32_make(Value value) {
        return Value.createInstance(new AtomicInteger(value.asInt32()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32_add_and_get(Value value, Value value2) {
        AtomicInteger atomicInteger = (AtomicInteger)value.asCustom();
        int n = atomicInteger.addAndGet(value2.asInt32());
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32", "int32"}, returnType="bool")
    public static Value ocamljava_atomicint32_compare_and_set(Value value, Value value2, Value value3) {
        AtomicInteger atomicInteger = (AtomicInteger)value.asCustom();
        boolean bl = atomicInteger.compareAndSet(value2.asInt32(), value3.asInt32());
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t"}, returnType="int32")
    public static Value ocamljava_atomicint32_decrement_and_get(Value value) {
        AtomicInteger atomicInteger = (AtomicInteger)value.asCustom();
        int n = atomicInteger.decrementAndGet();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t"}, returnType="int32")
    public static Value ocamljava_atomicint32_get(Value value) {
        AtomicInteger atomicInteger = (AtomicInteger)value.asCustom();
        int n = atomicInteger.get();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32_get_and_add(Value value, Value value2) {
        AtomicInteger atomicInteger = (AtomicInteger)value.asCustom();
        int n = atomicInteger.getAndAdd(value2.asInt32());
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t"}, returnType="int32")
    public static Value ocamljava_atomicint32_get_and_decrement(Value value) {
        AtomicInteger atomicInteger = (AtomicInteger)value.asCustom();
        int n = atomicInteger.getAndDecrement();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t"}, returnType="int32")
    public static Value ocamljava_atomicint32_get_and_increment(Value value) {
        AtomicInteger atomicInteger = (AtomicInteger)value.asCustom();
        int n = atomicInteger.getAndIncrement();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32_get_and_set(Value value, Value value2) {
        AtomicInteger atomicInteger = (AtomicInteger)value.asCustom();
        int n = atomicInteger.getAndSet(value2.asInt32());
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t"}, returnType="int32")
    public static Value ocamljava_atomicint32_increment_and_get(Value value) {
        AtomicInteger atomicInteger = (AtomicInteger)value.asCustom();
        int n = atomicInteger.incrementAndGet();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32"}, returnType="unit")
    public static Value ocamljava_atomicint32_lazy_set(Value value, Value value2) {
        AtomicInteger atomicInteger = (AtomicInteger)value.asCustom();
        atomicInteger.lazySet(value2.asInt32());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32"}, returnType="unit")
    public static Value ocamljava_atomicint32_set(Value value, Value value2) {
        AtomicInteger atomicInteger = (AtomicInteger)value.asCustom();
        atomicInteger.set(value2.asInt32());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32", "int32"}, returnType="bool")
    public static Value ocamljava_atomicint32_weak_compare_and_set(Value value, Value value2, Value value3) {
        AtomicInteger atomicInteger = (AtomicInteger)value.asCustom();
        boolean bl = atomicInteger.weakCompareAndSet(value2.asInt32(), value3.asInt32());
        return bl ? Value.TRUE : Value.FALSE;
    }
}

