/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/draw.c")
public final class Draw {
    private Draw() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="unit")
    public static Value caml_gr_plot(Value vx, Value vy) throws FailException {
        Graphics2D store;
        GraphSlot slot = GraphSlot.checkGraph();
        int x = vx.asCastedInt();
        int y = slot.convertY(vy.asCastedInt());
        Graphics2D win = slot.createWindowGraphics();
        if (win != null) {
            win.setStroke(new BasicStroke(1.0f));
            win.drawLine(x, y, x, y);
            win.dispose();
            slot.repaint();
        }
        if ((store = slot.createBackingStoreGraphics()) != null) {
            store.setStroke(new BasicStroke(1.0f));
            store.drawLine(x, y, x, y);
            store.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="unit")
    public static Value caml_gr_moveto(Value vx, Value vy) throws FailException {
        GraphSlot slot = GraphSlot.checkGraph();
        slot.setX(vx.asCastedInt());
        slot.setY(vy.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_gr_current_x(Value unit) throws FailException {
        return Value.createLong(GraphSlot.checkGraph().getX());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_gr_current_y(Value unit) throws FailException {
        return Value.createLong(GraphSlot.checkGraph().getY());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="unit")
    public static Value caml_gr_lineto(Value vx, Value vy) throws FailException {
        Graphics2D store;
        GraphSlot slot = GraphSlot.checkGraph();
        int x0 = slot.getX();
        int y0 = slot.convertY(slot.getY());
        int x1 = vx.asCastedInt();
        int y1 = vy.asCastedInt();
        Graphics2D win = slot.createWindowGraphics();
        if (win != null) {
            win.drawLine(x0, y0, x1, slot.convertY(y1));
            win.dispose();
            slot.repaint();
        }
        if ((store = slot.createBackingStoreGraphics()) != null) {
            store.drawLine(x0, y0, x1, slot.convertY(y1));
            store.dispose();
        }
        slot.setX(x1);
        slot.setY(y1);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "int"}, returnType="unit")
    public static Value caml_gr_draw_rect(Value vx, Value vy, Value vw, Value vh) throws FailException {
        Graphics2D store;
        GraphSlot slot = GraphSlot.checkGraph();
        int w = vw.asCastedInt();
        int h = vh.asCastedInt();
        int x = vx.asCastedInt();
        int y = slot.convertY(vy.asCastedInt()) - h;
        Graphics2D win = slot.createWindowGraphics();
        if (win != null) {
            win.drawRect(x, y, w, h);
            win.dispose();
            slot.repaint();
        }
        if ((store = slot.createBackingStoreGraphics()) != null) {
            store.drawRect(x, y, w, h);
            store.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "int", "int", "int"}, returnType="unit")
    public static Value caml_gr_draw_arc(Value vx, Value vy, Value vrx, Value vry, Value va1, Value va2) throws FailException {
        Graphics2D store;
        GraphSlot slot = GraphSlot.checkGraph();
        int rx = vrx.asCastedInt();
        int ry = vry.asCastedInt();
        int x = vx.asCastedInt() - rx;
        int y = slot.convertY(vy.asCastedInt()) - ry;
        int w = rx * 2;
        int h = ry * 2;
        int sa = va1.asCastedInt();
        int aa = va2.asCastedInt() - sa;
        Graphics2D win = slot.createWindowGraphics();
        if (win != null) {
            win.drawArc(x, y, w, h, sa, aa);
            win.dispose();
            slot.repaint();
        }
        if ((store = slot.createBackingStoreGraphics()) != null) {
            store.drawArc(x, y, w, h, sa, aa);
            store.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "int", "int", "int"}, returnType="unit")
    public static Value caml_gr_draw_arc_nat(Value vx, Value vy, Value vrx, Value vry, Value va1, Value va2) throws FailException {
        return Draw.caml_gr_draw_arc(vx, vy, vrx, vry, va1, va2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="unit")
    public static Value caml_gr_set_line_width(Value lw) throws FailException {
        GraphSlot.checkGraph().setLineWidth(lw.asCastedInt());
        return Value.UNIT;
    }
}

