/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ForkJoinThreadFactory;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ForkJoinPool", source="")
public final class ForkJoinPool {
    private ForkJoinPool() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32", "bool"}, returnType="ForkJoinPool.t")
    public static Value ocamljava_forkjoinpool_make(Value parallelism, Value asyncMode) throws FailException {
        try {
            ForkJoinThreadFactory factory = new ForkJoinThreadFactory(OCamlJavaThread.getCodeRunner());
            java.util.concurrent.ForkJoinPool res = new java.util.concurrent.ForkJoinPool(parallelism.asInt32(), factory, null, asyncMode != Value.FALSE);
            return Value.createInstance(res);
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.ForkJoinPool.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "int64", "TimeUnit.t"}, returnType="int32")
    public static Value ocamljava_forkjoinpool_await_termination(Value obj, Value timeout, Value unit) throws FailException {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        try {
            return inst.awaitTermination(timeout.asInt64(), TimeUnit.decode(unit)) ? Value.TRUE : Value.FALSE;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.ForkJoinPool.await_termination");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int32")
    public static Value ocamljava_forkjoinpool_get_active_thread_count(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return Value.createInt32(inst.getActiveThreadCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="bool")
    public static Value ocamljava_forkjoinpool_get_async_mode(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return inst.getAsyncMode() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int32")
    public static Value ocamljava_forkjoinpool_get_parallelism(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return Value.createInt32(inst.getParallelism());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int32")
    public static Value ocamljava_forkjoinpool_get_pool_size(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return Value.createInt32(inst.getPoolSize());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int32")
    public static Value ocamljava_forkjoinpool_get_queued_submission_count(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return Value.createInt32(inst.getQueuedSubmissionCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int64")
    public static Value ocamljava_forkjoinpool_get_queued_task_count(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return Value.createInt64(inst.getQueuedTaskCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int32")
    public static Value ocamljava_forkjoinpool_get_running_thread_count(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return Value.createInt32(inst.getRunningThreadCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="int64")
    public static Value ocamljava_forkjoinpool_get_steal_count(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return Value.createInt64(inst.getStealCount());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="bool")
    public static Value ocamljava_forkjoinpool_has_queued_submissions(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return inst.hasQueuedSubmissions() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="bool")
    public static Value ocamljava_forkjoinpool_is_quiescent(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return inst.isQuiescent() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="bool")
    public static Value ocamljava_forkjoinpool_is_shutdown(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return inst.isShutdown() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="bool")
    public static Value ocamljava_forkjoinpool_is_terminated(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return inst.isTerminated() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="bool")
    public static Value ocamljava_forkjoinpool_is_terminating(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        return inst.isTerminating() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="unit")
    public static Value ocamljava_forkjoinpool_shutdown(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        inst.shutdown();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t"}, returnType="unit")
    public static Value ocamljava_forkjoinpool_shutdown_now(Value obj) {
        java.util.concurrent.ForkJoinPool inst = (java.util.concurrent.ForkJoinPool)obj.asCustom();
        inst.shutdownNow();
        return Value.UNIT;
    }
}

