/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.scripting;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.ocamljava.runtime.annotations.parameters.Parameters;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.Interpreter;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.support.scripting.OCamlBindings;
import org.ocamljava.runtime.support.scripting.OCamlCompiledScript;
import org.ocamljava.runtime.support.scripting.OCamlContext;
import org.ocamljava.runtime.support.scripting.OCamlScriptEngineFactory;
import org.ocamljava.runtime.util.CustomClassLoader;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.util.RedirectedInputStream;
import org.ocamljava.runtime.util.RedirectedOutputStream;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class OCamlScriptEngine
implements ScriptEngine,
Compilable,
Invocable {
    private static final AtomicInteger ID = new AtomicInteger();
    private static Method COMPILER_MAIN;
    private ScriptContext context = new OCamlContext();
    private final Interpreter interpreter;
    private final List<String> libraryPaths = new LinkedList<String>();
    private final List<String> libraries = new LinkedList<String>();
    private final RedirectedInputStream in = new RedirectedInputStream(System.in);
    private final RedirectedOutputStream out = new RedirectedOutputStream(System.out);
    private final RedirectedOutputStream err = new RedirectedOutputStream(System.err);
    private PrintStream printOut = new PrintStream(this.out);
    private PrintStream printErr = new PrintStream(this.err);

    public OCamlScriptEngine() throws RuntimeException {
        try {
            InputStream inputStream = OCamlScriptEngine.class.getResourceAsStream("/script");
            RandomAccessInputStream randomAccessInputStream = new RandomAccessInputStream(inputStream);
            ByteCodeParameters byteCodeParameters = Parameters.defaultByteCodeParameters();
            byteCodeParameters = Parameters.setFile(byteCodeParameters, "/script");
            byteCodeParameters = Parameters.setBooleanParameter(byteCodeParameters, CommonParameters.BooleanParameterID.STOP_JVM, false);
            byteCodeParameters = Parameters.setInputStreamParameter(byteCodeParameters, CommonParameters.InputStreamParameterID.IN, (InputStream)this.in);
            byteCodeParameters = Parameters.setPrintStreamParameter(byteCodeParameters, CommonParameters.PrintStreamParameterID.OUT, this.printOut);
            byteCodeParameters = Parameters.setPrintStreamParameter(byteCodeParameters, CommonParameters.PrintStreamParameterID.ERR, this.printErr);
            byteCodeParameters = Parameters.setBooleanParameter(byteCodeParameters, CommonParameters.BooleanParameterID.EMBEDDED, true);
            this.interpreter = new Interpreter(byteCodeParameters, new File("."), randomAccessInputStream, new CustomOperations[0]);
            randomAccessInputStream.close();
            this.interpreter.execute();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create script engine", iOException);
        }
        catch (FatalError fatalError) {
            throw new RuntimeException("Unable to create script engine", fatalError);
        }
        catch (OCamlJavaException oCamlJavaException) {
            throw new RuntimeException("Unable to create script engine", oCamlJavaException);
        }
    }

    public void addLibraryPath(String string) throws NullPointerException, ScriptException {
        if (string != null) {
            if (!this.libraryPaths.contains(string)) {
                this.libraryPaths.add(string);
            }
            try {
                this.interpreter.execute("ocamljava javax.script.directory", Value.createString(string));
            }
            catch (OCamlJavaException oCamlJavaException) {
                throw new ScriptException(oCamlJavaException);
            }
        } else {
            throw new NullPointerException();
        }
    }

    public void loadLibrary(String string) throws NullPointerException, ScriptException {
        if (string != null) {
            if (!this.libraries.contains(string)) {
                this.libraries.add(string);
            }
            try {
                this.interpreter.execute("ocamljava javax.script.load", Value.createString(string + ".cma"));
            }
            catch (OCamlJavaException oCamlJavaException) {
                throw new ScriptException(oCamlJavaException);
            }
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public Bindings createBindings() {
        return new OCamlBindings();
    }

    @Override
    public Object eval(Reader reader) throws NullPointerException, ScriptException {
        try {
            return this.evaluate(OCamlScriptEngine.readerToString(reader), OCamlContext.instance(this.context));
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws NullPointerException, ScriptException {
        try {
            return this.evaluate(OCamlScriptEngine.readerToString(reader), new OCamlContext(OCamlContext.instance(this.context), OCamlBindings.instance(bindings)));
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws NullPointerException, ScriptException {
        try {
            return this.evaluate(OCamlScriptEngine.readerToString(reader), OCamlContext.instance(scriptContext));
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
    }

    @Override
    public Object eval(String string) throws NullPointerException, ScriptException {
        return this.evaluate(string, OCamlContext.instance(this.context));
    }

    @Override
    public Object eval(String string, Bindings bindings) throws NullPointerException, ScriptException {
        return this.evaluate(string, new OCamlContext(OCamlContext.instance(this.context), OCamlBindings.instance(bindings)));
    }

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws NullPointerException, ScriptException {
        return this.evaluate(string, OCamlContext.instance(scriptContext));
    }

    @Override
    public Object get(String string) throws NullPointerException, IllegalArgumentException {
        return this.getBindings(100).get(string);
    }

    @Override
    public Bindings getBindings(int n) throws IllegalArgumentException {
        return this.context.getBindings(n);
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return new OCamlScriptEngineFactory();
    }

    @Override
    public void put(String string, Object object) throws NullPointerException, IllegalArgumentException {
        this.getBindings(100).put(string, object);
    }

    @Override
    public void setBindings(Bindings bindings, int n) throws NullPointerException, IllegalArgumentException {
        this.context.setBindings(bindings, n);
    }

    @Override
    public void setContext(ScriptContext scriptContext) throws NullPointerException {
        this.context = scriptContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompiledScript compile(String string) throws NullPointerException, ScriptException {
        if (string == null) {
            throw new NullPointerException("null script");
        }
        if (COMPILER_MAIN == null) {
            throw new ScriptException("OCaml-Java compiler is not available");
        }
        try {
            int n = ID.getAndIncrement();
            String string2 = "org.ocamljava.runtime.support.scripting.generated" + n;
            File file = File.createTempFile("ocamlscript", ".ml");
            File file2 = File.createTempFile("ocamlscript", ".jar");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            ((Writer)fileWriter).close();
            LinkedList<String> linkedList = new LinkedList<String>();
            for (Object object : this.libraryPaths) {
                linkedList.add("-I");
                linkedList.add((String)object);
            }
            String[] stringArray = this.libraries.iterator();
            while (true) {
                Object object;
                if (!stringArray.hasNext()) {
                    linkedList.add("-w");
                    linkedList.add("-a");
                    linkedList.add("-scripting");
                    linkedList.add("-runtime-parameter");
                    linkedList.add("stop-jvm=off");
                    linkedList.add("-java-package");
                    linkedList.add(string2);
                    linkedList.add("-o");
                    linkedList.add(file2.getAbsolutePath());
                    linkedList.add(file.getAbsolutePath());
                    stringArray = linkedList.toArray(new String[linkedList.size()]);
                    COMPILER_MAIN.invoke(null, new Object[]{stringArray});
                    object = new URLClassLoader(new URL[]{new URL("file://" + file2.getAbsolutePath())}, (ClassLoader)CustomClassLoader.INSTANCE);
                    Class<?> clazz = Class.forName(string2 + ".ocamljavaMain", true, (ClassLoader)object);
                    Method method = clazz.getMethod("mainScripting", String[].class, Map.class, InputStream.class, PrintStream.class, PrintStream.class);
                    return new OCamlCompiledScript(this, method, this.context);
                }
                object = stringArray.next();
                linkedList.add((String)object + ".cmja");
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ScriptException("Unable to compile script");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ScriptException("Unable to compile script");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ScriptException("Unable to compile script");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ScriptException("Unable to compile script");
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
    }

    @Override
    public CompiledScript compile(Reader reader) throws NullPointerException, ScriptException {
        if (reader == null) {
            throw new NullPointerException("null script");
        }
        try {
            return this.compile(OCamlScriptEngine.readerToString(reader));
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
    }

    @Override
    public Object invokeMethod(Object object, String string, Object ... objectArray) throws ScriptException, NoSuchMethodException, NullPointerException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invokeFunction(String string, Object ... objectArray) throws ScriptException, NoSuchMethodException, NullPointerException {
        try {
            this.out.flush();
            this.err.flush();
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        OCamlContext oCamlContext = OCamlContext.instance(this.context);
        this.in.redirect(oCamlContext.getStdIn());
        this.out.redirect(oCamlContext.getStdOut());
        this.err.redirect(oCamlContext.getStdErr());
        try {
            int n = objectArray.length;
            Value[] valueArray = new Value[n];
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return this.interpreter.execute(string, valueArray);
                }
                valueArray[n2] = OCamlBindings.convert(objectArray[n2]);
                ++n2;
            }
        }
        catch (OCamlJavaException oCamlJavaException) {
            throw new ScriptException(oCamlJavaException);
        }
    }

    @Override
    public <T> T getInterface(Class<T> clazz) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getInterface(Object object, Class<T> clazz) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    private Object evaluate(String string, OCamlContext oCamlContext) throws ScriptException {
        assert (string != null) : "null script";
        assert (oCamlContext != null) : "null context";
        try {
            this.out.flush();
            this.err.flush();
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        this.in.redirect(oCamlContext.getStdIn());
        this.out.redirect(oCamlContext.getStdOut());
        this.err.redirect(oCamlContext.getStdErr());
        try {
            String string2 = string + "\n";
            return this.interpreter.executeWithBindings("ocamljava javax.script.eval", oCamlContext.getBindings(), Value.createString(string2));
        }
        catch (OCamlJavaException oCamlJavaException) {
            Throwable throwable = oCamlJavaException.getCause();
            if (throwable instanceof FailException) {
                Value value;
                FailException failException = (FailException)throwable;
                Value value2 = failException.getValue();
                Value value3 = value = value2.isBlock() && value2.asBlock().sizeValues() >= 2L ? value2.asBlock().get1() : null;
                if (value != null && value.isBlock() && value.getTag() == 252) {
                    throw new ScriptException(value.asString());
                }
                throw new ScriptException(oCamlJavaException);
            }
            if (throwable instanceof FatalError) {
                throw new ScriptException(throwable.getMessage());
            }
            throw new ScriptException(oCamlJavaException);
        }
    }

    private static String readerToString(Reader reader) throws IOException {
        assert (reader != null) : "null reader";
        int n = 1024;
        StringWriter stringWriter = new StringWriter(1024);
        char[] cArray = new char[1024];
        int n2 = reader.read(cArray);
        while (n2 != -1) {
            stringWriter.write(cArray, 0, n2);
            n2 = reader.read(cArray);
        }
        return stringWriter.toString();
    }

    static {
        try {
            Class<?> clazz = Class.forName("ocaml.compilers.ocamljavaMain");
            COMPILER_MAIN = clazz.getMethod("mainWithReturn", String[].class);
        }
        catch (Throwable throwable) {
            COMPILER_MAIN = null;
        }
    }
}

