/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/readlink.c")
public final class Readlink {
    private Readlink() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string")
    public static Value unix_readlink(Value value) throws FailException {
        try {
            Path path = Files.readSymbolicLink(CurrentContext.FILES_STATE.getRealFile(value).toPath());
            return Value.createString(path.toAbsolutePath().toString());
        }
        catch (IOException iOException) {
            Unix.fail("readlink", iOException);
            return Value.UNIT;
        }
    }
}

