/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/fcntl.c")
public final class Fcntl {
    private Fcntl() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr"}, returnType="unit")
    public static Value unix_set_nonblock(Value value) throws FailException {
        Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
        if (channel == null) {
            Unix.fail("read", "invalid descriptor");
        }
        try {
            channel.configureBlocking(false);
        }
        catch (IOException iOException) {
            Unix.fail("set_nonblock", iOException);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr"}, returnType="unit")
    public static Value unix_clear_nonblock(Value value) throws FailException {
        Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
        if (channel == null) {
            Unix.fail("read", "invalid descriptor");
        }
        try {
            channel.configureBlocking(true);
        }
        catch (IOException iOException) {
            Unix.fail("clear_nonblock", iOException);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.NOT_IMPLEMENTED, parameterTypes={"Unix.file_descr"}, returnType="unit")
    public static Value unix_set_close_on_exec(Value value) throws FailException {
        Fail.invalidArgument("Unix.set_close_on_exec not implemented");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.NOT_IMPLEMENTED, parameterTypes={"Unix.file_descr"}, returnType="unit")
    public static Value unix_clear_close_on_exec(Value value) throws FailException {
        Fail.invalidArgument("Unix.clear_close_on_exec not implemented");
        return Value.UNIT;
    }
}

