/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlNumber;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.SimpleWrapper;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlFloat
extends OCamlValue
implements OCamlNumber {
    public static final Wrapper<OCamlFloat> WRAPPER = new SimpleWrapper<OCamlFloat>(){

        @Override
        public OCamlFloat wrap(Value value) {
            return new OCamlFloat(value);
        }
    };

    private OCamlFloat(Value value) {
        super(value);
    }

    public Wrapper<? extends OCamlFloat> getWrapper() {
        return WRAPPER;
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int n) {
        return OCamlUnit.WRAPPER;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value.asDouble();
    }

    @Override
    public double doubleValue() {
        return this.value.asDouble();
    }

    @Override
    public float floatValue() {
        return (float)this.value.asDouble();
    }

    @Override
    public int intValue() {
        return (int)this.value.asDouble();
    }

    @Override
    public long longValue() {
        return (long)this.value.asDouble();
    }

    @Override
    public short shortValue() {
        return (short)this.value.asDouble();
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.value.asDouble());
        return (int)(l ^ l >>> 32);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OCamlFloat) {
            OCamlFloat oCamlFloat = (OCamlFloat)object;
            return this.value.asDouble() == oCamlFloat.value.asDouble();
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OCamlFloat(");
        stringBuilder.append(this.value.asDouble());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static OCamlFloat create(double d) {
        return new OCamlFloat(Value.createDouble(d));
    }

    public static OCamlFloat wrap(Value value) {
        assert (value != null) : "null v";
        return new OCamlFloat(value);
    }

    public static Wrapper<? extends OCamlFloat> wrapper() {
        return WRAPPER;
    }
}

